﻿<# 
DisableDomainCreds-Remediation.ps1
Disable the local storage of passwords and credentials
Determines whether Credential Manager saves passwords or credentials locally for later use when it gains domain authentication.
Locally cached passwords or credentials can be accessed by malicious code or unauthorized users.
 #>

try
{
    
    $REG_Path = "HKLM:SYSTEM\CurrentControlSet\Control\Lsa"
    $REG_Value = (Get-ItemProperty -Path $REG_Path -ErrorAction SilentlyContinue).DisableDomainCreds


    if ($REG_Value -ne "1")
    {
        Remove-ItemProperty -Path $REG_Path -Name "DisableDomainCreds" -Force -ErrorAction SilentlyContinue
        New-ItemProperty -Path $REG_Path -Name "DisableDomainCreds" -Value "1"  -PropertyType Dword -ErrorAction SilentlyContinue
    }

    else

    {    
        exit 0
    }  
} 

catch
{
    $errMsg = $_.Exception.Message
    Write-Error $errMsg
    exit 1
}