﻿<# 
AccountLockoutSettings-Remediation.ps1
Set 'Account lockout threshold' to 1-10 invalid login attempts
Set 'Account lockout duration' to 15 minutes or more
Set 'Reset account lockout counter after' to 15 minutes or more
 #>

try
{
   
    $LockoutThreshold = net accounts | select-string "lockout threshold" 
    $LockoutDuration = net accounts | select-string "Lockout duration" 
    $LockoutObservationWindow = net accounts | select-string "Lockout observation window" 
    
    
    if($LockoutThreshold -like "*Never")
    {
        $LockoutThreshold_Value = "0"
    } 


    if($LockoutDuration -notlike "*15")
    {
        $LockoutDuration_Value = "0"
    } 

    if($LockoutObservationWindow -notlike "*15")
    {
        $LockoutObservationWindow_Value = "0"
    } 
    

    if ($LockoutThreshold_Value -eq "0")
    {
        net accounts /lockoutthreshold:10
    }

    if($LockoutDuration_Value -eq "0")
    {
        net accounts /lockoutduration:15
    }

    if($LockoutObservationWindow_Value -eq "0")
    {
        net accounts /lockoutwindow:15
    }

    else

    {  
     
        exit 0
    }  
} 

catch
{
    $errMsg = $_.Exception.Message
    Write-Error $errMsg
    exit 1
}